/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.config;

import com.xiangcao.xiangcaomengjia.block.SellingBinTier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class XiangcaoTierConfig {
    private static final Map<SellingBinTier, TierEntry> ENTRIES = new HashMap<SellingBinTier, TierEntry>();
    private static ForgeConfigSpec CONFIG_SPEC;
    private static ForgeConfigSpec.BooleanValue SHOW_RECYCLING_PRICE_TOOLTIP;
    private static ForgeConfigSpec.ConfigValue<String> RECYCLING_PRICE_TOOLTIP_STYLE;
    private static ForgeConfigSpec.BooleanValue PRICE_VARIATION_ENABLED;
    private static ForgeConfigSpec.DoubleValue PRICE_MULTIPLIER_MIN;
    private static ForgeConfigSpec.DoubleValue PRICE_MULTIPLIER_MAX;
    private static ForgeConfigSpec.DoubleValue PRICE_RANDOM_PERCENT;
    private static ForgeConfigSpec.BooleanValue PRICE_REFRESH_ON_SLEEP;
    private static ForgeConfigSpec.IntValue PRICE_REFRESH_PERIOD_MINUTES;
    private static ForgeConfigSpec.BooleanValue PRICE_MANUAL_REFRESH_ALLOWED;
    private static ForgeConfigSpec.BooleanValue SUPPLY_DROP_ENABLED;
    private static ForgeConfigSpec.IntValue SUPPLY_DROP_STACKS_PER_STEP;
    private static ForgeConfigSpec.DoubleValue SUPPLY_DROP_PERCENT_PER_STEP;
    private static ForgeConfigSpec.DoubleValue SUPPLY_DROP_MAX_PERCENT;
    private static ForgeConfigSpec.BooleanValue SUPPLY_DECAY_ON_REFRESH;
    private static ForgeConfigSpec.DoubleValue SUPPLY_DECAY_FACTOR;
    private static ForgeConfigSpec.BooleanValue DEMAND_BONUS_ENABLED;
    private static ForgeConfigSpec.IntValue DEMAND_BONUS_TICKS_PER_STEP;
    private static ForgeConfigSpec.DoubleValue DEMAND_BONUS_PERCENT_PER_STEP;
    private static ForgeConfigSpec.DoubleValue DEMAND_BONUS_MAX_PERCENT;
    private static ForgeConfigSpec.BooleanValue PRICE_SPIKE_ENABLED;
    private static ForgeConfigSpec.DoubleValue PRICE_SPIKE_CHANCE;
    private static ForgeConfigSpec.DoubleValue PRICE_SPIKE_MULTIPLIER;
    private static ForgeConfigSpec.DoubleValue PRICE_CAP_MAX;
    private static ForgeConfigSpec.DoubleValue PRICE_CAP_MIN;
    private static ForgeConfigSpec.BooleanValue BULK_BONUS_ENABLED;
    private static ForgeConfigSpec.IntValue BULK_BONUS_STACKS;
    private static ForgeConfigSpec.DoubleValue BULK_BONUS_PERCENT;
    private static ForgeConfigSpec.BooleanValue VARIETY_BONUS_ENABLED;
    private static ForgeConfigSpec.IntValue VARIETY_BONUS_TYPES;
    private static ForgeConfigSpec.DoubleValue VARIETY_BONUS_PERCENT;
    private static ForgeConfigSpec.DoubleValue MARKET_FEE_PERCENT;
    private static ForgeConfigSpec.BooleanValue FIRST_SELL_BONUS_ENABLED;
    private static ForgeConfigSpec.DoubleValue FIRST_SELL_BONUS_PERCENT;

    public static ForgeConfigSpec getSpec() {
        return CONFIG_SPEC;
    }

    public static int getUpdateDelayTicks(SellingBinTier tier) {
        int v;
        TierEntry e = ENTRIES.get((Object)tier);
        if (e != null && e.updateDelayTicks != null && (v = ((Integer)e.updateDelayTicks.get()).intValue()) > 0) {
            return v;
        }
        return tier.updateDelayTicks;
    }

    public static int getMaxProcessPerTick(SellingBinTier tier) {
        int v;
        TierEntry e = ENTRIES.get((Object)tier);
        if (e != null && e.maxProcessPerTick != null && (v = ((Integer)e.maxProcessPerTick.get()).intValue()) > 0) {
            return v >= 999999 ? Integer.MAX_VALUE : v;
        }
        return tier.maxProcessPerTick;
    }

    public static boolean showRecyclingPriceTooltip() {
        return SHOW_RECYCLING_PRICE_TOOLTIP != null && (Boolean)SHOW_RECYCLING_PRICE_TOOLTIP.get() != false;
    }

    public static boolean recyclingPriceTooltipIconStyle() {
        return RECYCLING_PRICE_TOOLTIP_STYLE != null && "icon".equalsIgnoreCase((String)RECYCLING_PRICE_TOOLTIP_STYLE.get());
    }

    public static boolean priceVariationEnabled() {
        return PRICE_VARIATION_ENABLED != null && (Boolean)PRICE_VARIATION_ENABLED.get() != false;
    }

    public static double priceMultiplierMin() {
        return PRICE_MULTIPLIER_MIN != null ? (Double)PRICE_MULTIPLIER_MIN.get() : 0.8;
    }

    public static double priceMultiplierMax() {
        return PRICE_MULTIPLIER_MAX != null ? (Double)PRICE_MULTIPLIER_MAX.get() : 1.2;
    }

    public static double priceRandomPercent() {
        return PRICE_RANDOM_PERCENT != null ? (Double)PRICE_RANDOM_PERCENT.get() : 0.0;
    }

    public static boolean priceRefreshOnSleep() {
        return PRICE_REFRESH_ON_SLEEP != null && (Boolean)PRICE_REFRESH_ON_SLEEP.get() != false;
    }

    public static int priceRefreshPeriodMinutes() {
        return PRICE_REFRESH_PERIOD_MINUTES != null ? (Integer)PRICE_REFRESH_PERIOD_MINUTES.get() : 0;
    }

    public static boolean priceManualRefreshAllowed() {
        return PRICE_MANUAL_REFRESH_ALLOWED != null && (Boolean)PRICE_MANUAL_REFRESH_ALLOWED.get() != false;
    }

    public static boolean supplyDropEnabled() {
        return SUPPLY_DROP_ENABLED != null && (Boolean)SUPPLY_DROP_ENABLED.get() != false;
    }

    public static int supplyDropStacksPerStep() {
        return SUPPLY_DROP_STACKS_PER_STEP != null ? (Integer)SUPPLY_DROP_STACKS_PER_STEP.get() : 3;
    }

    public static double supplyDropPercentPerStep() {
        return SUPPLY_DROP_PERCENT_PER_STEP != null ? (Double)SUPPLY_DROP_PERCENT_PER_STEP.get() : 5.0;
    }

    public static double supplyDropMaxPercent() {
        return SUPPLY_DROP_MAX_PERCENT != null ? (Double)SUPPLY_DROP_MAX_PERCENT.get() : 50.0;
    }

    public static boolean supplyDecayOnRefresh() {
        return SUPPLY_DECAY_ON_REFRESH != null && (Boolean)SUPPLY_DECAY_ON_REFRESH.get() != false;
    }

    public static double supplyDecayFactor() {
        return SUPPLY_DECAY_FACTOR != null ? (Double)SUPPLY_DECAY_FACTOR.get() : 0.5;
    }

    public static boolean demandBonusEnabled() {
        return DEMAND_BONUS_ENABLED != null && (Boolean)DEMAND_BONUS_ENABLED.get() != false;
    }

    public static int demandBonusTicksPerStep() {
        return DEMAND_BONUS_TICKS_PER_STEP != null ? (Integer)DEMAND_BONUS_TICKS_PER_STEP.get() : 6000;
    }

    public static double demandBonusPercentPerStep() {
        return DEMAND_BONUS_PERCENT_PER_STEP != null ? (Double)DEMAND_BONUS_PERCENT_PER_STEP.get() : 1.0;
    }

    public static double demandBonusMaxPercent() {
        return DEMAND_BONUS_MAX_PERCENT != null ? (Double)DEMAND_BONUS_MAX_PERCENT.get() : 15.0;
    }

    public static boolean priceSpikeEnabled() {
        return PRICE_SPIKE_ENABLED != null && (Boolean)PRICE_SPIKE_ENABLED.get() != false;
    }

    public static double priceSpikeChance() {
        return PRICE_SPIKE_CHANCE != null ? (Double)PRICE_SPIKE_CHANCE.get() : 0.2;
    }

    public static double priceSpikeMultiplier() {
        return PRICE_SPIKE_MULTIPLIER != null ? (Double)PRICE_SPIKE_MULTIPLIER.get() : 1.5;
    }

    public static double priceCapMax() {
        return PRICE_CAP_MAX != null ? (Double)PRICE_CAP_MAX.get() : 0.0;
    }

    public static double priceCapMin() {
        return PRICE_CAP_MIN != null ? (Double)PRICE_CAP_MIN.get() : 0.0;
    }

    public static boolean bulkBonusEnabled() {
        return BULK_BONUS_ENABLED != null && (Boolean)BULK_BONUS_ENABLED.get() != false;
    }

    public static int bulkBonusStacks() {
        return BULK_BONUS_STACKS != null ? (Integer)BULK_BONUS_STACKS.get() : 4;
    }

    public static double bulkBonusPercent() {
        return BULK_BONUS_PERCENT != null ? (Double)BULK_BONUS_PERCENT.get() : 5.0;
    }

    public static boolean varietyBonusEnabled() {
        return VARIETY_BONUS_ENABLED != null && (Boolean)VARIETY_BONUS_ENABLED.get() != false;
    }

    public static int varietyBonusTypes() {
        return VARIETY_BONUS_TYPES != null ? (Integer)VARIETY_BONUS_TYPES.get() : 5;
    }

    public static double varietyBonusPercent() {
        return VARIETY_BONUS_PERCENT != null ? (Double)VARIETY_BONUS_PERCENT.get() : 3.0;
    }

    public static double marketFeePercent() {
        return MARKET_FEE_PERCENT != null ? (Double)MARKET_FEE_PERCENT.get() : 0.0;
    }

    public static boolean firstSellBonusEnabled() {
        return FIRST_SELL_BONUS_ENABLED != null && (Boolean)FIRST_SELL_BONUS_ENABLED.get() != false;
    }

    public static double firstSellBonusPercent() {
        return FIRST_SELL_BONUS_PERCENT != null ? (Double)FIRST_SELL_BONUS_PERCENT.get() : 5.0;
    }

    private static String tierNameCn(SellingBinTier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case SellingBinTier.WOOD -> "\u6728";
            case SellingBinTier.IRON -> "\u94c1";
            case SellingBinTier.GOLD -> "\u91d1";
            case SellingBinTier.DIAMOND -> "\u94bb\u77f3";
            case SellingBinTier.NETHERITE -> "\u4e0b\u754c\u5408\u91d1";
        };
    }

    public static void register() {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.comment("\u51fa\u8d27\u7bb1\u8bbe\u7f6e\u4fee\u6539\u540e\u9700\u91cd\u542f\u6e38\u620f\u6216\u91cd\u8fdb\u5b58\u6863\u751f\u6548").push("tiers");
        b.pop();
        b.comment("\u56de\u6536\u4ef7\u4e0e\u6807\u7b7e\u663e\u793a").push("display");
        SHOW_RECYCLING_PRICE_TOOLTIP = b.comment("\u662f\u5426\u5728\u7269\u54c1\u63d0\u793a\u4e2d\u663e\u793a\u56de\u6536\u4ef7").define("showRecyclingPriceTooltip", true);
        RECYCLING_PRICE_TOOLTIP_STYLE = b.comment("\u56de\u6536\u4ef7\u663e\u793a\uff1a\u8d34\u56fe\u663e\u793a=\u9ec4\u5b57\u300c\u51fa\u552e\u6b64\u5546\u54c1\u53ef\u83b7\u5f97\u300d+\u7269\u54c1\u8d34\u56fe+\u4ef7\u683c\uff1b\u6587\u5b57\u663e\u793a=\u7eff\u8272\u300c\u2192 X \u8d22\u4ea7\u70b9\u6570\u300d\u3002\u586b icon \u6216 text\u3002\u9ed8\u8ba4\uff1aicon").define("recyclingPriceTooltipStyle", (Object)"icon");
        b.pop();
        b.comment(new String[]{"\u4ef7\u683c\u53d8\u52a8", "\u300c\u5468\u671f\u300d= \u4e24\u6b21\u4ef7\u683c\u5237\u65b0\u4e4b\u95f4\u7684\u65f6\u95f4\uff1b\u6bcf\u6b21\u5237\u65b0\u4f1a\u91cd\u7b97\u500d\u7387\u3001\u91cd\u7f6e\u300c\u672c\u5468\u671f\u9996\u6b21\u51fa\u552e\u300d\u7b49\u3002", "\u5468\u671f\u7531\u4e0b\u9762\u5237\u65b0\u65b9\u5f0f\u51b3\u5b9a\uff1a", "\u00b7 \u7761\u9192\u5237\u65b0\u5f00\u542f\u65f6\uff1a\u6bcf\u7761\u4e00\u89c9\u5237\u65b0 \u2192 \u5468\u671f \u2248 \u4e00\u6e38\u620f\u65e5\uff08\u7ea6 20 \u5206\u949f\u73b0\u5b9e\u65f6\u95f4\uff09", "\u00b7 \u5468\u671f\u5237\u65b0\u95f4\u9694>0 \u65f6\uff1a\u6bcf N \u5206\u949f\u5237\u65b0 \u2192 \u5468\u671f = \u4e0b\u9762 refreshPeriodMinutes\uff08\u53ef\u81ea\u5b9a\u4e49\uff09", "\u00b7 \u624b\u52a8\u5237\u65b0\uff1a\u6267\u884c /xiangcaomengjia refreshPrice \u65f6\u5237\u65b0 \u2192 \u5468\u671f = \u4e24\u6b21\u6307\u4ee4\u4e4b\u95f4"}).push("priceVariation");
        PRICE_VARIATION_ENABLED = b.define("enabled", false);
        PRICE_MULTIPLIER_MIN = b.comment("\u5237\u65b0\u65f6\u500d\u7387\u4e0b\u9650\uff0c\u5982 0.8 \u8868\u793a 80%").defineInRange("multiplierMin", 0.8, 0.01, 10.0);
        PRICE_MULTIPLIER_MAX = b.comment("\u5237\u65b0\u65f6\u500d\u7387\u4e0a\u9650\uff0c\u5982 1.2 \u8868\u793a 120%").defineInRange("multiplierMax", 1.2, 0.01, 10.0);
        PRICE_RANDOM_PERCENT = b.comment("\u6bcf\u6b21\u8ba1\u4ef7\u968f\u673a\u6d6e\u52a8\u767e\u5206\u6bd4\uff0c\u5982 5 \u8868\u793a \u00b15%\uff0c0 \u8868\u793a\u4e0d\u968f\u673a").defineInRange("randomPercent", 0.0, 0.0, 100.0);
        PRICE_REFRESH_ON_SLEEP = b.comment("\u6bcf\u5929\u7761\u9192\u65f6\u5237\u65b0\u4ef7\u683c\u500d\u7387\uff08\u6b64\u65f6\u5468\u671f=\u4e00\u6e38\u620f\u65e5\uff09").define("refreshOnSleep", true);
        PRICE_REFRESH_PERIOD_MINUTES = b.comment("\u5468\u671f\u957f\u5ea6\uff08\u5206\u949f\uff09\uff1a\u6bcf\u8fc7\u8fd9\u4e48\u591a\u5206\u949f\u81ea\u52a8\u5237\u65b0\u4e00\u6b21\uff0c0=\u4e0d\u6309\u65f6\u95f4\u5468\u671f\u5237\u65b0\u3002\u4f8b\u5982 60 \u5373 1 \u5c0f\u65f6\u4e00\u5468\u671f").defineInRange("refreshPeriodMinutes", 0, 0, 10000);
        PRICE_MANUAL_REFRESH_ALLOWED = b.comment("\u5141\u8bb8\u4f7f\u7528\u6307\u4ee4\u624b\u52a8\u5237\u65b0\u4ef7\u683c\u500d\u7387").define("manualRefreshAllowed", true);
        SUPPLY_DROP_ENABLED = b.comment("\u540c\u79cd\u4f5c\u7269\u5356\u5f97\u8d8a\u591a\u4ef7\u683c\u8d8a\u4f4e").define("supplyDropEnabled", true);
        SUPPLY_DROP_STACKS_PER_STEP = b.comment("\u6bcf\u5356\u51e0\u7ec4\u7b97\u4e00\u6863\uff0c\u9ed8\u8ba43").defineInRange("supplyDropStacksPerStep", 3, 1, 64);
        SUPPLY_DROP_PERCENT_PER_STEP = b.comment("\u6bcf\u6863\u8dcc\u4ef7\u767e\u5206\u6bd4\uff0c\u9ed8\u8ba45").defineInRange("supplyDropPercentPerStep", 5.0, 0.0, 100.0);
        SUPPLY_DROP_MAX_PERCENT = b.comment("\u6700\u591a\u8dcc\u5230\u539f\u4ef7\u7684\u767e\u5206\u4e4b\u591a\u5c11\uff0c\u9ed8\u8ba450\u5373\u6700\u4f4e50%").defineInRange("supplyDropMaxPercent", 50.0, 1.0, 100.0);
        SUPPLY_DECAY_ON_REFRESH = b.comment("\u5237\u65b0\u65f6\u5df2\u552e\u6570\u91cf\u6309\u6bd4\u4f8b\u8870\u51cf\uff0c\u4e0d\u76f4\u63a5\u6e05\u7a7a").define("supplyDecayOnRefresh", true);
        SUPPLY_DECAY_FACTOR = b.comment("\u8870\u51cf\u4fdd\u7559\u6bd4\u4f8b\uff0c0.5\u5373\u5269\u4e00\u534a\uff0c0\u5373\u6e05\u7a7a").defineInRange("supplyDecayFactor", 0.5, 0.0, 1.0);
        DEMAND_BONUS_ENABLED = b.comment("\u4e45\u672a\u51fa\u552e\u7684\u7269\u54c1\u6da8\u4ef7").define("demandBonusEnabled", true);
        DEMAND_BONUS_TICKS_PER_STEP = b.comment("\u591a\u5c11tick\u672a\u5356\u7b97\u4e00\u6863\uff0c6000\u7ea65\u5206\u949f").defineInRange("demandBonusTicksPerStep", 6000, 100, 1000000);
        DEMAND_BONUS_PERCENT_PER_STEP = b.comment("\u6bcf\u6863\u52a0\u4ef7\u767e\u5206\u6bd4").defineInRange("demandBonusPercentPerStep", 1.0, 0.0, 100.0);
        DEMAND_BONUS_MAX_PERCENT = b.comment("\u9700\u6c42\u52a0\u6210\u6700\u591a\u52a0\u591a\u5c11%").defineInRange("demandBonusMaxPercent", 15.0, 0.0, 100.0);
        PRICE_SPIKE_ENABLED = b.comment("\u5237\u65b0\u65f6\u968f\u673a\u4e00\u4e2a\u7269\u54c1\u672c\u5468\u671f\u6da8\u4ef7").define("priceSpikeEnabled", true);
        PRICE_SPIKE_CHANCE = b.comment("\u89e6\u53d1\u6982\u73870~1").defineInRange("priceSpikeChance", 0.2, 0.0, 1.0);
        PRICE_SPIKE_MULTIPLIER = b.comment("\u6da8\u4ef7\u500d\u7387").defineInRange("priceSpikeMultiplier", 1.5, 1.0, 5.0);
        PRICE_CAP_MAX = b.comment("\u603b\u500d\u7387\u4e0a\u9650\uff0c0\u4e3a\u4e0d\u9650\u5236").defineInRange("priceCapMax", 0.0, 0.0, 10.0);
        PRICE_CAP_MIN = b.comment("\u603b\u500d\u7387\u4e0b\u9650\uff0c0\u4e3a\u4e0d\u9650\u5236\uff0c\u907f\u514d\u8dcc\u7a7f").defineInRange("priceCapMin", 0.0, 0.0, 1.0);
        BULK_BONUS_ENABLED = b.comment("\u5355\u6b21\u51fa\u552e\u8fbe\u5230\u6307\u5b9a\u7ec4\u6570\u65f6\u989d\u5916\u52a0\u6210").define("bulkBonusEnabled", true);
        BULK_BONUS_STACKS = b.comment("\u8fbe\u5230\u51e0\u7ec4\u89e6\u53d1\u6279\u91cf\u52a0\u6210").defineInRange("bulkBonusStacks", 4, 1, 64);
        BULK_BONUS_PERCENT = b.comment("\u6279\u91cf\u52a0\u6210\u767e\u5206\u6bd4").defineInRange("bulkBonusPercent", 5.0, 0.0, 100.0);
        VARIETY_BONUS_ENABLED = b.comment("\u672c\u5468\u671f\u51fa\u552e\u7269\u54c1\u79cd\u7c7b\u6570\u8fbe\u5230\u6307\u5b9a\u6570\u91cf\u65f6\u52a0\u6210").define("varietyBonusEnabled", true);
        VARIETY_BONUS_TYPES = b.comment("\u51fa\u552e\u51e0\u79cd\u4e0d\u540c\u7269\u54c1\u540e\u89e6\u53d1\u79cd\u7c7b\u52a0\u6210").defineInRange("varietyBonusTypes", 5, 2, 64);
        VARIETY_BONUS_PERCENT = b.comment("\u79cd\u7c7b\u52a0\u6210\u767e\u5206\u6bd4").defineInRange("varietyBonusPercent", 3.0, 0.0, 100.0);
        MARKET_FEE_PERCENT = b.comment("\u6bcf\u7b14\u624b\u7eed\u8d39\u767e\u5206\u6bd4\uff0c0\u4e3a\u65e0").defineInRange("marketFeePercent", 0.0, 0.0, 50.0);
        FIRST_SELL_BONUS_ENABLED = b.comment("\u672c\u5468\u671f\u9996\u6b21\u51fa\u552e\u67d0\u7269\u54c1\u65f6\u7ed9\u4e00\u6b21\u52a0\u6210").define("firstSellBonusEnabled", true);
        FIRST_SELL_BONUS_PERCENT = b.comment("\u9996\u6b21\u51fa\u552e\u52a0\u6210\u767e\u5206\u6bd4").defineInRange("firstSellBonusPercent", 5.0, 0.0, 100.0);
        b.pop();
        b.push("tiers");
        for (SellingBinTier tier : SellingBinTier.values()) {
            b.comment(XiangcaoTierConfig.tierNameCn(tier) + "\u51fa\u8d27\u7bb1\u6863\u4f4d").push(tier.name);
            TierEntry entry = new TierEntry();
            entry.updateDelayTicks = b.comment("\u4e24\u6b21\u51fa\u8d27\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20=1\u79d2\uff09\u3002\u9ed8\u8ba4\uff1a" + tier.updateDelayTicks).defineInRange("updateDelayTicks", tier.updateDelayTicks, 1, Integer.MAX_VALUE);
            int defaultMax = tier.maxProcessPerTick == Integer.MAX_VALUE ? 999999 : tier.maxProcessPerTick;
            entry.maxProcessPerTick = b.comment("\u6bcf\u6b21\u51fa\u8d27\u6700\u591a\u5904\u7406\u7269\u54c1\u6570\u91cf\u3002\u586b 999999 \u8868\u793a\u5168\u90e8\u3002\u9ed8\u8ba4\uff1a" + (Serializable)(tier.maxProcessPerTick == Integer.MAX_VALUE ? "\u5168\u90e8" : Integer.valueOf(tier.maxProcessPerTick))).defineInRange("maxProcessPerTick", defaultMax, 1, Integer.MAX_VALUE);
            b.pop();
            ENTRIES.put(tier, entry);
        }
        b.pop();
        CONFIG_SPEC = b.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG_SPEC, "xiangcaomengjia-common.toml");
    }

    private static class TierEntry {
        ForgeConfigSpec.IntValue updateDelayTicks;
        ForgeConfigSpec.IntValue maxProcessPerTick;

        private TierEntry() {
        }
    }
}

